package com.ejie.ab04b.service.util;

import javax.annotation.Resource;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Clase para obtener el contexto de Spring y asi poder obtener instancias
 * dinamicamente
 * 
 * @author Alberto_Diez
 * 
 */
@Resource()
public class ApplicationContextProvider implements ApplicationContextAware {

	private static ApplicationContext context;

	/**
	 * Obtiene el contexto de la aplicacion para poder instanciar nuevos beans
	 * 
	 *  contexto de la aplicacion.
	 *
	 * @return the application context
	 */
	public static ApplicationContext getApplicationContext() {
		return ApplicationContextProvider.context;
	}

	/* (non-Javadoc)
	 * @see org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
	 */
	@Override()
	public void setApplicationContext(ApplicationContext ctx) {
		ApplicationContextProvider.context = ctx;
	}

}
